#include "Music.h"

#include <vector>
using namespace std;


CMusic::CMusic()
{
    okThread=false;
    fileName=NULL;
    File       = NULL;
    Format     = 0;
    SampleRate = 0;
    volume=0.8;
    srcM=0;
    pauze=false;
}

void CMusic::setVolume(float volume)
{
    this->volume=volume;
}

CMusic::~CMusic()
{
    stopMusic();
}

void CMusic::stopMusic()
{
    if(okThread)
    {
        okThread=false;
        pauze=false;
        pthread_join(musicThrd,NULL);
    }
}

////////////////////////////////////////////////////////////
/// Ouvre le fichier ogg-vorbis
///
/// \param Filename : Nom du fichier ogg  ouvrir
///
/// \return True si tout s'est bien pass, false en cas d'erreur
///
////////////////////////////////////////////////////////////
bool CMusic::OpenOgg(char *fineName)
{
    // Ouverture du fichier
    File = fopen(fineName, "rb");
    if (!File)
    {
        //std::cerr << "Impossible d'ouvrir le fichier audio" << std::endl;
        return false;
    }

    // On ouvre un flux ogg-vorbis  partir du fichier que l'on vient d'ouvrir
    int Error = ov_open(File, &Stream, NULL, 0);
    if (Error < 0)
    {
        //std::cerr << "Impossible de lire les donnes ogg-vorbis  partir du fichier" << std::endl;
        return false;
    }

    // Rcupration des informations du son
    vorbis_info* Infos = ov_info(&Stream, -1);
    Format     = Infos->channels == 1 ? AL_FORMAT_MONO16 : AL_FORMAT_STEREO16;
    SampleRate = Infos->rate;

    return true;
}


////////////////////////////////////////////////////////////
/// Lit des chantillons  partir du flux ogg-vorbis
///
/// \param Buffer :    Identificateur du tampon OpenAL  remplir avec les chantillons
/// \param NbSamples : Nombre maximum d'chantillons  lire
///
////////////////////////////////////////////////////////////
bool CMusic::ReadOgg(ALuint Buffer, ALsizei NbSamples)
{
    bool res=true;
    
    // Tableau qui va recevoir les chantillons lus
    std::vector<ALshort> Samples(NbSamples);

    // Dfinition de variables utiles  la lecture
    ALsizei TotalRead  = 0;
    ALsizei TotalSize  = NbSamples * sizeof(ALshort);
    char*   SamplesPtr = reinterpret_cast<char*>(&Samples[0]);

    // Tant qu'on n'a pas atteint la taille voulue, on lit
    while (TotalRead < TotalSize)
    {
        // Lecture des chantillons  partir du flux ogg-vorbis
        ALsizei Read = ov_read(&Stream, SamplesPtr + TotalRead, TotalSize - TotalRead, 0, 2, 1, NULL);

        if (Read > 0)
        {
            // La lecture a russi, on avance du nombre d'octets lus
            TotalRead += Read;
        }
        else
        {
            // La lecture a chou, on arrte de lire
            if(TotalRead==0)res=false;
            break;
        }
    }

    // Remplissage du tampon avec les donnes lues
    if (TotalRead > 0)
        alBufferData(Buffer, Format, &Samples[0], TotalRead, SampleRate);
        
    return res;
}


////////////////////////////////////////////////////////////
/// Ferme le fichier ogg-vorbis
///
////////////////////////////////////////////////////////////
void CMusic::CloseOgg()
{
    // Fermeture du flux ogg-vorbis
    ov_clear(&Stream);

    // Fermeture du fichier
    fclose(File);
}

void CMusic::launchMusic(char *fileName)
{
    if(fileName)
    {
        stopMusic();
        this->fileName=fileName;
        pauze=false;
        this->okThread=true;
        pthread_create(&musicThrd,NULL,threadMusic,(void*)this);
    }
}

void CMusic::launchMusicListID(unsigned short int nbMusic,char **listFileName,unsigned char id,bool loopM)
{
    if(nbMusic && listFileName && *listFileName && **listFileName)
    {
        stopMusic();
        this->id=id;
        this->nbMusic=nbMusic;
        this->listFileName=listFileName;
        this->loopM=loopM;
        this->okThread=true;
        pauze=false;
        pthread_create(&musicThrd,NULL,threadMusicList,(void*)this);
    }
}

void CMusic::launchMusicList(unsigned short int nbMusic,char **listFileName,bool loopM)
{
    if(nbMusic && listFileName && *listFileName && **listFileName)
    {
        if(this->listFileName!=listFileName || this->nbMusic!=nbMusic)
            launchMusicListID(nbMusic,listFileName,0,loopM);
        else
            launchMusicListID(nbMusic,listFileName,id,loopM);
    }
}

////////////////////////////////////////////////////////////
/// Initialise OpenAL (ouvre un device et cre un contexte audio)
///
/// \param DeviceName : Nom du device  ouvrir (NULL pour le device par dfaut)
///
/// \return True si tout s'est bien pass, false en cas d'erreur
///
////////////////////////////////////////////////////////////
bool CMusic::InitOpenAL(const char* DeviceName)
{
    // Ouverture du device
    ALCdevice* Device = alcOpenDevice(DeviceName);
    if (!Device)
    {
        //std::cerr << "Impossible d'ouvrir le device par dfaut" << std::endl;
        return false;
    }

    // Cration du contexte
    ALCcontext* Context = alcCreateContext(Device, NULL);
    if (!Context)
    {
        //std::cerr << "Impossible de crer un contexte audio" << std::endl;
        return false;
    }

    // Activation du contexte
    if (!alcMakeContextCurrent(Context))
    {
        //std::cerr << "Impossible d'activer le contexte audio" << std::endl;
        return false;
    }

    return true;
}

////////////////////////////////////////////////////////////
/// Ferme proprement OpenAL
///
////////////////////////////////////////////////////////////
void CMusic::ShutdownOpenAL()
{
    // Rcupration du contexte et du device
    ALCcontext* Context = alcGetCurrentContext();
    ALCdevice*  Device  = alcGetContextsDevice(Context);

    // Dsactivation du contexte
    alcMakeContextCurrent(NULL);

    // Destruction du contexte
    alcDestroyContext(Context);

    // Fermeture du device
    alcCloseDevice(Device);
}

void CMusic::play()
{
    if(srcM && pauze)
    {
        pauze=false;
        alSourcePlay(srcM);
    }
}

void CMusic::pause()
{
    if(srcM && !pauze)
    {
        pauze=true;
        alSourceStop(srcM);
    }
}

#define myts ((CMusic*)data)

void *threadMusic(void *data)
{ 
    if(!myts->fileName)return NULL;
    
    if(myts->OpenOgg(myts->fileName))
    {
        bool lecture;
        
        // Cration des deux tampons OpenAL que nous allons utiliser pour la lecture en flux
        ALuint Buffers[4];
        alGenBuffers(4, Buffers);
        
        // Cration de la source qui jouera le son
        ALuint Source;
        alGenSources(1, &Source);
        myts->srcM=Source;
        
        alSourcef(Source,AL_GAIN,myts->volume);
        
        // Remplissage des tampons avec le dbut du son  jouer
        myts->ReadOgg(Buffers[0], 44100);
        myts->ReadOgg(Buffers[1], 44100);
        myts->ReadOgg(Buffers[2], 44100);
        lecture=myts->ReadOgg(Buffers[3], 44100);
        
        // On ajoute les 4 tampons  la file de la source
        alSourceQueueBuffers(Source, 4, Buffers);
        
        // On peut commencer la lecture
        alSourcePlay(Source);
        
        ALint Status;
        do
        {
            if(lecture)Sleep(100);
            else Sleep(10);
            // On rcupre le nombre de tampons qui ont t traits (ie. qui sont prts  tre rutiliss)
            ALint NbProcessed;
            alGetSourcei(Source, AL_BUFFERS_PROCESSED, &NbProcessed);
        
            // On les re-remplit et on les rinjecte dans la file
            for (ALint i = 0; i < NbProcessed; ++i)
            {
                // On sort le tampon de la file
                ALuint Buffer;
                alSourceUnqueueBuffers(Source, 1, &Buffer);
        
                // On le remplit avec les donnes du fichier
                lecture=myts->ReadOgg(Buffer, 44100);
                
                if(lecture)
                {
                    // On le rinjecte dans la file
                    alSourceQueueBuffers(Source, 1, &Buffer);
                }
            }
        
            // On rcupre l'tat de la source
            alGetSourcei(Source, AL_SOURCE_STATE, &Status);
        }
        while ((Status == AL_PLAYING || myts->pauze) && myts->okThread);
        
        // On purge la file de tampons de la source
        ALint  NbQueued;
        ALuint Buffer;
        alGetSourcei(Source, AL_BUFFERS_QUEUED, &NbQueued);
        for (ALint i = 0; i < NbQueued; ++i)
            alSourceUnqueueBuffers(Source, 1, &Buffer);
        alSourcei(Source, AL_BUFFER, 0);
        
        // On dtruit les quatre tampons
        alDeleteBuffers(4, Buffers);
        
        // On dtruit la source
        myts->srcM=0;
        alDeleteSources(1, &Source);
        
        myts->CloseOgg();
    }
    else return NULL;
    //myts->okThread=false;
    
    return ((void*)1);
}

unsigned char CMusic::setId(unsigned char id)
{
    this->id=id;
}

unsigned char CMusic::getId()
{
    return id;
}

void *threadMusicList(void *data)
{
    do
    {
        myts->fileName=myts->listFileName[myts->id];
        if(myts->fileName)
        {
            if(!threadMusic(data))Sleep(2000);
        }
        
        myts->id++;
        if((myts->id)>=(myts->nbMusic))
        {
            if(myts->loopM)myts->id=0;
            else myts->okThread=false;
        }
    }
    while(myts->okThread);
    
    //myts->okThread=false;
    return NULL;
}
